/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public record PackageOrderWithCrafts(PackageOrder orderedStacks, List<CraftingEntry> orderedCrafts) {
    public static PackageOrderWithCrafts empty() {
        return new PackageOrderWithCrafts(PackageOrder.empty(), List.of());
    }

    public static PackageOrderWithCrafts simple(List<BigItemStack> orderedStacks) {
        return new PackageOrderWithCrafts(new PackageOrder(orderedStacks), List.of());
    }

    public static PackageOrderWithCrafts singleRecipe(List<BigItemStack> pattern) {
        return new PackageOrderWithCrafts(PackageOrder.empty(), List.of(new CraftingEntry(new PackageOrder(pattern), 1)));
    }

    public static boolean hasCraftingInformation(PackageOrderWithCrafts context) {
        if (context == null) {
            return false;
        }
        return context.orderedCrafts.size() == 1;
    }

    public List<BigItemStack> getCraftingInformation() {
        return this.orderedCrafts.get((int)0).pattern.stacks();
    }

    public List<BigItemStack> stacks() {
        return this.orderedStacks.stacks();
    }

    public boolean isEmpty() {
        return this.orderedStacks.isEmpty();
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10566("OrderedStacks", (class_2520)this.orderedStacks.write());
        tag.method_10566("OrderedCrafts", (class_2520)NBTHelper.writeCompoundList(this.orderedCrafts, CraftingEntry::write));
        return tag;
    }

    public static PackageOrderWithCrafts read(class_2487 tag) {
        if (tag.method_10573("Entries", 9)) {
            return new PackageOrderWithCrafts(PackageOrder.read(tag), List.of());
        }
        return new PackageOrderWithCrafts(PackageOrder.read(tag.method_10562("OrderedStacks")), NBTHelper.readCompoundList((class_2499)tag.method_10554("OrderedCrafts", 10), CraftingEntry::read));
    }

    public void write(class_2540 buffer) {
        this.orderedStacks.write(buffer);
        buffer.method_10804(this.orderedCrafts.size());
        this.orderedCrafts.forEach(ce -> ce.write(buffer));
    }

    public static PackageOrderWithCrafts read(class_2540 buffer) {
        PackageOrder orderedStacks = PackageOrder.read(buffer);
        ArrayList<CraftingEntry> orderedCrafts = new ArrayList<CraftingEntry>();
        int size = buffer.method_10816();
        for (int i = 0; i < size; ++i) {
            orderedCrafts.add(CraftingEntry.read(buffer));
        }
        return new PackageOrderWithCrafts(orderedStacks, orderedCrafts);
    }

    public boolean orderedStacksMatchOrderedRecipes() {
        if (this.orderedCrafts.isEmpty()) {
            return false;
        }
        InventorySummary stacks = new InventorySummary();
        InventorySummary crafts = new InventorySummary();
        this.stacks().forEach(stacks::add);
        this.orderedCrafts.forEach(ce -> ce.pattern.stacks().forEach(bis -> crafts.add(new BigItemStack(bis.stack, bis.count * ce.count))));
        List<BigItemStack> stackEntries = stacks.getStacks();
        if (stackEntries.size() != crafts.getStacks().size()) {
            return false;
        }
        for (BigItemStack bis : stackEntries) {
            if (crafts.getCountOf(bis.stack) == bis.count) continue;
            return false;
        }
        return true;
    }

    public record CraftingEntry(PackageOrder pattern, int count) {
        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10566("Pattern", (class_2520)this.pattern.write());
            tag.method_10569("Count", this.count);
            return tag;
        }

        public static CraftingEntry read(class_2487 tag) {
            return new CraftingEntry(PackageOrder.read(tag.method_10562("Pattern")), tag.method_10550("Count"));
        }

        public void write(class_2540 buffer) {
            this.pattern.write(buffer);
            buffer.method_10804(this.count);
        }

        public static CraftingEntry read(class_2540 buffer) {
            return new CraftingEntry(PackageOrder.read(buffer), buffer.method_10816());
        }
    }
}

